// Create a file called test.txt in the current directory:
using (Stream s = new FileStream ("test.txt", FileMode.Create))
{
	Console.WriteLine (s.CanRead);       // True
	Console.WriteLine (s.CanWrite);      // True
	Console.WriteLine (s.CanSeek);       // True

	s.WriteByte (101);
	s.WriteByte (102);
	byte[] block = { 1, 2, 3, 4, 5 };
	s.Write (block, 0, block.Length);     // Zapis bloku 5 bajtów

	Console.WriteLine (s.Length);         // 7
	Console.WriteLine (s.Position);       // 7
	s.Position = 0;                       // Powrót na początek

	Console.WriteLine (s.ReadByte());     // 101
	Console.WriteLine (s.ReadByte());     // 102

	// Odczyt ze strumienia z powrotem do tablicy blokowej:
	Console.WriteLine (s.Read (block, 0, block.Length));   // 5

	// Założenie, że ostatni odczyt zwrócił 5, będziemy na
	// końcu pliku, więc teraz Read zwróci 0:
	Console.WriteLine (s.Read (block, 0, block.Length));   // 0
}